#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Peripheral Drift InverseMod01.fsh  by  copperbotte   
//https://www.shadertoy.com/view/ssjyDG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*3.14159   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// The classical optical illusion. Blue background, orange center. +v is +x.
// UV space is (0,1) in both axes.
vec3 optical_illusion(in vec2 uv)
{
    const vec3 color_bg = vec3(1,0.5,0);
    const vec3 color_fg = vec3(0,0,1);
    const vec3 color_forw = vec3(0);
    const vec3 color_back = vec3(1);
    const float r_o = 0.9;
    const float r_i = 0.7;
    
    vec2 xy = mod(uv, 1.0) * 2.0 - 1.0;
    float r2 = dot(xy, xy);
    float r_o2 = r_o*r_o;
    float r_i2 = r_i*r_i;
    
    // Smoothly interpolate the ifs to prevent branching
    // Thanks Fabrice!
    const float dx = 0.05;
    float r2smooth_out = smoothstep(r_o2-dx, r_o2+dx, r2);
    float r2smooth_in = smoothstep(r_i2-dx, r_i2+dx, r2);

    float xsmooth = smoothstep(-dx, dx, xy.x);
    
    vec3 xcolor = mix(color_back, color_forw, xsmooth);
    vec3 forecolor = mix(color_fg, xcolor, r2smooth_in);
    return mix(forecolor, color_bg, r2smooth_out);
}

// Generate a ray to march
void generate_ray(in vec2 xy, out vec3 rPos, out vec3 rDir)
{
    rPos = vec3(0,0,2); // 2 from the center of the torus, right handed coordinates.
    
    vec3 dir = vec3(xy, -1);
    rDir = normalize(dir);
}

// The torus sdf SHOULD BE the closest point on the tangencial ring?
// Inputs in world position
float Sdf(in vec3 wPos, in float inner_rad, in float outer_rad)
{   
    // Align the world position to the inner ring
    vec2 rPos = vec2(length(wPos.xz), wPos.y);
    
    // Compute the offset from the outer ring
    rPos -= vec2(outer_rad, 0);
    
    //SDF is this distance, offset from inner_rad
    float sdf = length(rPos) - inner_rad;
    
    return sdf;
}


// SDF Raymarch
vec3 raymarch(in vec3 rPos, in vec3 rDir, in float inner_rad, in float outer_rad)
{
    vec3 sPos = rPos;
    
    float dir = sign(Sdf(sPos, inner_rad, outer_rad));
    
    for(int i=0; i<1000; ++i)
    {
        float sdf = Sdf(sPos, inner_rad, outer_rad);
        sPos += rDir * dir * sdf;
        if(abs(sdf) < 1e-4)
            return sPos;
    }
    
    return sPos;
}


// Color each world position according to the location on the torus
vec3 color_wpos(in vec3 wPos, in float inner_rad, in float outer_rad, in float speed, in vec2 scale)
{
    // get the torus angles
    float phi = atan(wPos.z, wPos.x);
    float r = length(wPos.xz);
    float theta = atan(wPos.y, r - outer_rad);
    
    phi = phi - speed*iTime;
    
    return optical_illusion(scale*vec2(phi, theta)/3.141592);
}

// Seperate sample function for integration
vec3 sample_image( in vec2 uv )
{
    // Correct for aspect ratio, convert so 0 is the center
    vec2 xy = uv * 2.0 - 1.0;
    xy.x *= iResolution.x/iResolution.y;
    
    vec3 col = vec3(0);

    /***************************************/
    /*         Tunable Parameters          */
    /***************************************/
    float inner_rad = 0.75;//0.5;//abs(0.9*sin(iTime) + 1.0);//
    float outer_rad = 2.1 - inner_rad;
    float speed = 2.5e-3; // radians per second
    vec2 scale = vec2(25.0, 10.0);
    
    vec3 rPos, rDir;
    generate_ray(xy, rPos, rDir);
    vec3 sPos = raymarch(rPos, rDir, inner_rad, outer_rad);
    
    if(abs(Sdf(sPos, inner_rad, outer_rad)) < 0.01)
        //col = vec3(length(sPos - rPos)/10.0);
        col = color_wpos(sPos, inner_rad, outer_rad, speed, scale);
    
    // Output to screen
    return col;
}

// random number generator **
// taken from iq :)
float seed;    //seed initialized in main
float rnd() { return fract(sin(seed++)*43758.5453123); }

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec3 col = vec3(0);
 
    const int samples = 4;
    const float s_f = float(samples);
 
    for(int i=0; i<samples; ++i)
    {
        vec2 rng = vec2(rnd(), rnd()) - 0.5;
        //vec2 rng = vec2(0);
    
        // Normalized pixel coordinates (from 0 to 1)
        vec2 uv = (fragCoord+rng)/iResolution.xy;
        vec3 C = sample_image(uv);
        C = pow(C, vec3(2.2));
        col += C;
    
    }
    
    col /= s_f;
    
    // adjust for srgb color space
    // rough approx
    col = pow(col, vec3(1.0/2.2));
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

